/* Toggle between adding and removing the "responsive" class to topnav when the user clicks on the icon */
function myFunction() {
    var x = document.getElementById("myTopnav");
    if (x.className === "topnav") {
        x.className += " responsive";
    } else {
        x.className = "topnav";
    }
}


const filters = {
    subject: '',
    location: '',
    duration: ''
};

function toggleDropdown(id) {
    document.getElementById(id).classList.toggle('show');
}

function setFilter(type, value) {
    filters[type] = value;
    document.getElementById(type + 'Btn').innerText = value || 'Any';
    filterSchools();
    closeAllDropdowns();
}

function filterFunction(dropdownId) {
    const input = document.querySelector(`#${dropdownId} input`);
    const filter = input.value.toUpperCase();
    const items = document.querySelectorAll(`#${dropdownId} a`);
    items.forEach(item => {
        item.style.display = item.innerText.toUpperCase().includes(filter) ? '' : 'none';
    });
}

function filterSchools() {
    const schools = document.querySelectorAll('.list-of-schools-items');
    schools.forEach(school => {
        const matchSubject = !filters.subject || school.dataset.subject === filters.subject;
        const matchLocation = !filters.location || school.dataset.location === filters.location;
        const matchDuration = !filters.duration || school.dataset.duration === filters.duration;

        school.style.display = (matchSubject && matchLocation && matchDuration) ? 'block' : 'none';
    });
}

function closeAllDropdowns() {
    document.querySelectorAll('.dropdown-content').forEach(dd => dd.classList.remove('show'));
}

// Optional: close dropdowns on outside click
window.onclick = function(e) {
    if (!e.target.matches('.dropbtn')) {
        closeAllDropdowns();
    }
}

// Map initialization
document.addEventListener('DOMContentLoaded', function() {
    // Only initialize map if we're on the home page (map element exists)
    const mapElement = document.getElementById('map');
    if (mapElement) {
        var map = L.map('map', {
            crs: L.CRS.Simple,
            minZoom: 0,
            maxZoom: 3,
            zoom: 1,
            gestureHandling: true,
            maxBounds: [[0, 0], [2500, 3554]],
            maxBoundsViscosity: 1.5
        });

        var imageUrl = 'MapChart_Map.png';
        var imageBounds = [[0, 0], [2500, 3554]];

        L.imageOverlay(imageUrl, imageBounds).addTo(map);
        map.fitBounds(imageBounds);
        map.setZoom(1);
    }
});

